Imports System.Net

Friend Class RemoteData


    Public Sub New()

    End Sub


    Public Sub Dispose()

    End Sub


    Public Shared Function GetPageSimple(ByVal URL As String, ByVal ConnectionTimeout As Integer) As String


        Dim PageData As String = ""

        Dim reqRequest As System.Net.HttpWebRequest = Nothing
        Dim reqResponse As System.Net.HttpWebResponse = Nothing


        Try

            reqRequest = CType(System.Net.WebRequest.Create(URL), HttpWebRequest)
            reqRequest.Timeout = ConnectionTimeout
            reqResponse = CType(reqRequest.GetResponse(), HttpWebResponse)
            PageData = ParseSuccessResponse(reqResponse)

        Catch ex As System.Net.WebException

            Dim ErrorResponseString As String

            If TypeOf ex.Response Is WebResponse Then
                ErrorResponseString = ParseErrorResponse(ex.Response)
            Else
                errorresponsestring = ex.Message
            End If
            If ErrorResponseString = "" Then ErrorResponseString = "An unknown error occurred."

            Try
                ex.Response.Close()
            Catch ex2 As Exception
            End Try

            Throw New Exception(ErrorResponseString)

        Catch ex As Exception

            Throw

        Finally

            If TypeOf reqResponse Is HttpWebResponse Then reqResponse.Close()
            reqRequest = Nothing

            reqResponse = Nothing

        End Try


        Return PageData


    End Function


    Private Shared Function ParseSuccessResponse(ByRef hwrResponse As HttpWebResponse) As String


        Dim ResponseString As String = "An unknown error occurred."

        Dim streamResponse As System.IO.Stream = Nothing
        Dim srRead As System.IO.StreamReader = Nothing


        Try

            If TypeOf hwrResponse Is HttpWebResponse Then


                'Get the stream associated with the response.
                streamResponse = hwrResponse.GetResponseStream()

                'Pipe the stream to a higher level stream reader.
                srRead = New System.IO.StreamReader(streamResponse, True)

                'Read the stream.
                ResponseString = srRead.ReadToEnd()

            End If

        Catch ex As Exception

        Finally

            If TypeOf srRead Is System.IO.StreamReader Then srRead.Close()
            srRead = Nothing

            streamResponse = Nothing

        End Try


        Return ResponseString


    End Function


    Private Shared Function ParseErrorResponse(ByRef wrResponse As WebResponse) As String


        Dim ResponseString As String = "An unknown error occurred."

        Dim streamResponse As System.IO.Stream = Nothing
        Dim ResponseBytes() As Byte


        Try

            If TypeOf wrResponse Is WebResponse Then

                streamResponse = wrResponse.GetResponseStream()
                ReDim ResponseBytes(streamResponse.Length)
                streamResponse.Read(ResponseBytes, 0, streamResponse.Length)
                ResponseString = System.Text.Encoding.ASCII.GetString(ResponseBytes)
                ResponseBytes = Nothing

            End If

        Catch ex As Exception

            Throw

        Finally

            If TypeOf streamResponse Is System.IO.Stream Then streamResponse.Close()
            streamResponse = Nothing

            ResponseBytes = Nothing

        End Try


        Return ResponseString


    End Function


End Class
